//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Argument and local variables - begin with a lowercase letter followed by
//        lowercase words separated by underscores.
//        (E.G., int my_local;).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


//******************************************************************************************************
//**** PROJECT HEADER FILES
//******************************************************************************************************
#include "ArrowButton.h"
#include "ArrowData.h"
#include "PrefilledBitmap.h"


//******************************************************************************************************
//**** TYPE DEFINITIONS AND CONSTANTS
//******************************************************************************************************


//******************************************************************************************************
//**** GLOBAL VARIABLES
//******************************************************************************************************


//******************************************************************************************************
//**** ArrowButton CLASS
//******************************************************************************************************
ArrowButton::ArrowButton(BRect frame, const char *name, const char *label, BMessage *message,
	ArrowOrientation orientation, uint32 resizingMode, uint32 flags)
: BControl(frame, name, label, message, resizingMode, flags)
{
	m_orientation = orientation;
	if(m_orientation == ARROW_UP || m_orientation == ARROW_DOWN)
		m_arrow_rect.Set(0,0,14,15);
	else
		m_arrow_rect.Set(0,0,15,14);
	for(int counter = 0; counter < 3; counter++)
		m_bitmaps[counter] = new PrefilledBitmap(m_arrow_rect,B_CMAP8,g_arrow_data[m_orientation][counter]);
	SetValue(B_CONTROL_OFF);
}


ArrowButton::~ArrowButton()
{
	for(int counter = 0; counter < 3; counter++)
		delete m_bitmaps[counter];
}


void ArrowButton::AttachedToWindow()
{
	m_window_activated = Window()->IsActive();
}


void ArrowButton::WindowActivated(bool state)
{
	m_window_activated = state;
	Invalidate();
}


void ArrowButton::Draw(BRect update_rect)
{
	ArrowBitmaps state;

	if(!m_window_activated || !IsEnabled())
		state = ARROW_DISABLED;
	else if(Value() == B_CONTROL_OFF)
		state = ARROW_ENABLED;
	else
		state = ARROW_ACTIVE;
	DrawBitmap(m_bitmaps[state],BPoint(0,0));
	//Get rid of a warning:
	update_rect.left = 0;
}


void ArrowButton::MouseDown(BPoint pt)
{
	if(IsEnabled())
	{
		Invalidate();
		SetValue(B_CONTROL_ON);
		thread_id follow_thread = spawn_thread(ArrowButton::FollowMouse,"arrow button thread",B_NORMAL_PRIORITY,
			new BMessenger(this));
		resume_thread(follow_thread);
	}
	//Get rid of a warning:
	pt.x = 0;
}


int32 ArrowButton::FollowMouse(void* data)
{
	BMessenger* target_messenger = (BMessenger*)data;
	int32 pulse_count = 0;
	while(true)
	{
		if (!target_messenger->LockTarget())
		{
			delete target_messenger;
			return 0;			// window is dead so exit
		}
		BLooper* target_looper;
		ArrowButton* target_view = (ArrowButton*)target_messenger->Target(&target_looper);
		BRect bounds = target_view->Bounds();
		BPoint where;
		uint32 buttons;
		target_view->GetMouse(&where,&buttons,false);
		if(buttons == 0)
		{
			target_view->SetValue(B_CONTROL_OFF);
			target_view->Invalidate();
		}
		else if(bounds.Contains(where))
		{
			//The button is held down inside the bounds
			if(target_view->Value() == B_CONTROL_OFF)
			{
				target_view->SetValue(B_CONTROL_ON);
				target_view->Invalidate();
			}
			//Invoke the control
			if(pulse_count == 0 || (pulse_count == 3 && target_view->m_scroll_enabled))
				target_view->Invoke();
		}
		else
		{
			//The button is held down outside the bounds
			if(target_view->Value() == B_CONTROL_ON)
			{
				target_view->SetValue(B_CONTROL_OFF);;
				target_view->Invalidate();
			}
		}
		target_looper->Unlock();	
		if(buttons == 0)
		{
			//Button was released
			delete target_messenger;
			return 0;
		}
		if(pulse_count < 3)
			pulse_count++;
		snooze(100000);
	}
}


void ArrowButton::SetEnabled(bool on)
{
	Invalidate();
	//Get rid of a warning:
	on = false;
}


void ArrowButton::GetPreferredSize(float *width, float *height)
{
	*width = m_arrow_rect.right-m_arrow_rect.left;
	*height = m_arrow_rect.bottom-m_arrow_rect.top;
}


void ArrowButton::SetScrollEnabled(bool state)
{
	m_scroll_enabled = state;
}


bool ArrowButton::GetScrollEnabled()
{
	return m_scroll_enabled;
}
